/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.mpeg.sampled.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import javazoom.spi.PropertiesContainer;
import javazoom.spi.mpeg.sampled.file.IcyListener;
import javazoom.spi.mpeg.sampled.file.tag.TagParseEvent;
import javazoom.spi.mpeg.sampled.file.tag.TagParseListener;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class DecodedMpegAudioInputStream
extends TAsynchronousFilteredAudioInputStream
implements PropertiesContainer,
TagParseListener {
    private InputStream m_encodedStream;
    private Bitstream m_bitstream;
    private Decoder m_decoder;
    private Equalizer m_equalizer;
    private float[] m_equalizer_values;
    private Header m_header;
    private DMAISObuffer m_oBuffer;
    private long byteslength = -1L;
    private long currentByte = 0L;
    private int frameslength = -1;
    private long currentFrame = 0L;
    private int currentFramesize = 0;
    private int currentBitrate = -1;
    private long currentMicrosecond = 0L;
    private IcyListener shoutlst = null;
    private HashMap properties = null;

    public DecodedMpegAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        super(audioFormat, -1L);
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">DecodedMpegAudioInputStream(AudioFormat outputFormat, AudioInputStream inputStream)");
        }
        try {
            this.byteslength = audioInputStream.available();
        }
        catch (IOException iOException) {
            TDebug.out("DecodedMpegAudioInputStream : Cannot run inputStream.available() : " + iOException.getMessage());
            this.byteslength = -1L;
        }
        this.m_encodedStream = audioInputStream;
        this.shoutlst = IcyListener.getInstance();
        this.shoutlst.reset();
        this.m_bitstream = new Bitstream(audioInputStream);
        this.m_decoder = new Decoder(null);
        this.m_equalizer = new Equalizer();
        this.m_equalizer_values = new float[32];
        for (int i = 0; i < this.m_equalizer.getBandCount(); ++i) {
            this.m_equalizer_values[i] = this.m_equalizer.getBand(i);
        }
        this.m_decoder.setEqualizer(this.m_equalizer);
        this.m_oBuffer = new DMAISObuffer(audioFormat.getChannels());
        this.m_decoder.setOutputBuffer(this.m_oBuffer);
        try {
            this.m_header = this.m_bitstream.readFrame();
            if (this.m_header != null && this.frameslength == -1 && this.byteslength > 0L) {
                this.frameslength = this.m_header.max_number_of_frames((int)this.byteslength);
            }
        }
        catch (BitstreamException bitstreamException) {
            TDebug.out("DecodedMpegAudioInputStream : Cannot read first frame : " + bitstreamException.getMessage());
            this.byteslength = -1L;
        }
        this.properties = new HashMap();
    }

    public Map properties() {
        this.properties.put("mp3.frame", new Long(this.currentFrame));
        this.properties.put("mp3.frame.bitrate", new Integer(this.currentBitrate));
        this.properties.put("mp3.frame.size.bytes", new Integer(this.currentFramesize));
        this.properties.put("mp3.position.byte", new Long(this.currentByte));
        this.properties.put("mp3.position.microseconds", new Long(this.currentMicrosecond));
        this.properties.put("mp3.equalizer", this.m_equalizer_values);
        if (this.shoutlst != null) {
            String string = this.shoutlst.getStreamUrl();
            String string2 = this.shoutlst.getStreamTitle();
            if (string2 != null && string2.trim().length() > 0) {
                this.properties.put("mp3.shoutcast.metadata.StreamTitle", string2);
            }
            if (string != null && string.trim().length() > 0) {
                this.properties.put("mp3.shoutcast.metadata.StreamUrl", string);
            }
        }
        return this.properties;
    }

    public void execute() {
        block11: {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("execute() : begin");
            }
            try {
                Header header = null;
                header = this.m_header == null ? this.m_bitstream.readFrame() : this.m_header;
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("execute() : header = " + header);
                }
                if (header == null) {
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("header is null (end of mpeg stream)");
                    }
                    this.getCircularBuffer().close();
                    return;
                }
                ++this.currentFrame;
                this.currentBitrate = header.bitrate_instant();
                this.currentFramesize = header.calculate_framesize();
                this.currentByte += (long)this.currentFramesize;
                this.currentMicrosecond = (long)((float)this.currentFrame * header.ms_per_frame() * 1000.0f);
                for (int i = 0; i < this.m_equalizer_values.length; ++i) {
                    this.m_equalizer.setBand(i, this.m_equalizer_values[i]);
                }
                this.m_decoder.setEqualizer(this.m_equalizer);
                Obuffer obuffer = this.m_decoder.decodeFrame(header, this.m_bitstream);
                this.m_bitstream.closeFrame();
                this.getCircularBuffer().write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
                this.m_oBuffer.reset();
                if (this.m_header != null) {
                    this.m_header = null;
                }
            }
            catch (BitstreamException bitstreamException) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out(bitstreamException);
                }
            }
            catch (DecoderException decoderException) {
                if (!TDebug.TraceAudioConverter) break block11;
                TDebug.out(decoderException);
            }
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("execute() : end");
        }
    }

    public long skip(long l) {
        if (this.byteslength > 0L && this.frameslength > 0) {
            float f = (float)l * 1.0f / (float)this.byteslength * 1.0f;
            long l2 = this.skipFrames((long)(f * (float)this.frameslength));
            this.currentByte += l2;
            this.m_header = null;
            return l2;
        }
        return -1L;
    }

    public long skipFrames(long l) {
        int n;
        int n2;
        block6: {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("skip(long frames) : begin");
            }
            n2 = 0;
            n = 0;
            try {
                int n3 = 0;
                while ((long)n3 < l) {
                    Header header = this.m_bitstream.readFrame();
                    if (header != null) {
                        int n4 = header.calculate_framesize();
                        n += n4;
                    }
                    this.m_bitstream.closeFrame();
                    ++n2;
                    ++n3;
                }
            }
            catch (BitstreamException bitstreamException) {
                if (!TDebug.TraceAudioConverter) break block6;
                TDebug.out(bitstreamException);
            }
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("skip(long frames) : end");
        }
        this.currentFrame += (long)n2;
        return n;
    }

    private boolean isBigEndian() {
        return this.getFormat().isBigEndian();
    }

    public void close() throws IOException {
        super.close();
        this.m_encodedStream.close();
    }

    public void tagParsed(TagParseEvent tagParseEvent) {
        System.out.println("TAG:" + tagParseEvent.getTag());
    }

    private class DMAISObuffer
    extends Obuffer {
        private int m_nChannels;
        private byte[] m_abBuffer;
        private int[] m_anBufferPointers;
        private boolean m_bIsBigEndian;

        public DMAISObuffer(int n) {
            this.m_nChannels = n;
            this.m_abBuffer = new byte[2304 * n];
            this.m_anBufferPointers = new int[n];
            this.reset();
            this.m_bIsBigEndian = DecodedMpegAudioInputStream.this.isBigEndian();
        }

        public void append(int n, short s) {
            byte by;
            byte by2;
            if (this.m_bIsBigEndian) {
                by2 = (byte)(s >>> 8 & 0xFF);
                by = (byte)(s & 0xFF);
            } else {
                by2 = (byte)(s & 0xFF);
                by = (byte)(s >>> 8 & 0xFF);
            }
            this.m_abBuffer[this.m_anBufferPointers[n]] = by2;
            this.m_abBuffer[this.m_anBufferPointers[n] + 1] = by;
            int n2 = n;
            this.m_anBufferPointers[n2] = this.m_anBufferPointers[n2] + this.m_nChannels * 2;
        }

        public void set_stop_flag() {
        }

        public void close() {
        }

        public void write_buffer(int n) {
        }

        public void clear_buffer() {
        }

        public byte[] getBuffer() {
            return this.m_abBuffer;
        }

        public int getCurrentBufferSize() {
            return this.m_anBufferPointers[0];
        }

        public void reset() {
            for (int i = 0; i < this.m_nChannels; ++i) {
                this.m_anBufferPointers[i] = i * 2;
            }
        }
    }
}

